#ifndef UNION_FIND_DELETE_H
#define UNION_FIND_DELETE_H

#include <list>
#include <vector>
#include <utility>

using namespace std;

typedef unsigned int uint;

#define UINT_NULL 0x7fffffff

class ListElem {
 public:
  uint p_node, prev, next;
 ListElem() :
  p_node(UINT_NULL), prev(UINT_NULL), next(UINT_NULL)
 {}
};

class ListBank {
  list < uint > freed;
  uint num_freed;
 public:
  vector <ListElem> d;           // implement a circular double list
  ListBank(uint init_size=1024);
  uint new_elem();               // create an empty element (p_node == UINT_NULL)
  bool free_elem(uint k);        // move the element to freed list (setting p_node = UINT_NULL, but does not change other fields).
  void append(uint q, uint& p);  // add q as the last element of the double list headed at p
  void insert_first(uint q, uint& p); // add q as the first element of the double list headed at p
  void merge_after_first(uint q, uint p); // add the entire list headed at q starting as the second element after p
  void move_out(uint q, uint& p); // move q out of the circular double list headed at p
  void insert_after(uint q, uint p); // insert q immediately after p in the circular double list headed at h (won't change)
  void insert_before(uint q, uint p, uint& h); // insert q immediately before p in the circular double list headed at h 
};

class TreeNode {
 public:
  uint item;
  uint p_parent;     // use p_parent == UINT_NULL to check if the node is in use.
  uint rank;
  
  uint head_clist;  // pointers to the head of its clist and nlist
  uint head_nlist;

  uint p_clist;  // pointers to its postion at the clist and nlist;
  uint p_nlist;

  uint p_dfs;      // pointers to its position at the dfs list

  uint size;       // size of the tree; only meaningful for the root node

 TreeNode() :
  item(0), p_parent(UINT_NULL), rank(0), \
    head_clist(UINT_NULL), head_nlist(UINT_NULL), \
    p_clist(UINT_NULL), p_nlist(UINT_NULL), \
    p_dfs(UINT_NULL), size(0)
 {}
};

class UnionFindDelete {
  vector < TreeNode > d;
  list < uint > freed;
  uint num_freed;
  
  ListBank clist;
  ListBank nlist;
  ListBank dfslist;

 public:
  vector <uint> item2pd;  // simple look up table from item to the location in d. May update in the future.
  
  UnionFindDelete(uint init_size=1024);

  void update_item2pd(uint item, uint pd);

  uint new_d();        // create an empty element (p_parent == UINT_NULL)
  bool free_d(uint k); // move the element to freed list (setting p_parent = UINT_NULL, but does not change other fields).
  
  uint makeset(uint item);

  uint union_(uint p_a, uint p_b);
  void add_single_node_no_clist_update(uint p, uint pf);
  void free_nlist(uint& pn);

  uint find_(uint a);
  
  inline bool isroot(uint a) {
    return (d[a].p_parent == a);
  }
  
  inline bool has_left_sibling(uint x);
  inline bool has_right_sibling(uint x);
  inline bool isleaf(uint a);
  inline uint left_sibling(uint x);
  void relink(uint a, uint p, uint gp);
  bool more_offsprings(uint p, int num);

  pair<uint, uint> delete_(uint a, uint r);  // return the pointer to a (first) and r (second) after delete (may change after swapping). r is the root.
  pair<uint, uint> reduced_tree_delete(uint a, uint r);
  uint find_leaf(uint a, uint r);
  pair<uint, uint> delete_leaf(uint a, uint r, uint option); // option = 0, no local rebuild; option = 1, local rebuild

  inline uint d_item(uint p) {
    return d[p].item;
  }

  inline uint d_size(uint p) {
    return d[p].size;
  }

  // test purpose
  void print_node(uint p);

  bool check_clist_recursively(uint a, uint r);
  void print_recursive_tree_items(uint a, uint r, FILE* oup);
  void print_one_layer_clist(uint a);

  void print_dfslist(uint a);
  //bool check_nlist(uint r);
  //bool check_dfs_list(uint r);

  bool check_from_dfslist(uint n_items);
  bool check_dfslist_one_root(uint root_pd);
};



// A comparison implementation of union-find-delete (to make sure its correctness)
class ListListBank {
  list < uint > freed;
  uint num_freed;
 public:
  vector < list<uint> > d;           
  ListListBank(uint init_size=1024);

  uint new_elem();               // create an empty element (p_node == UINT_NULL)
  bool free_elem(uint k);        // move the element to freed list (setting p_node = UINT_NULL, but does not change other fields).  
};

class SimpleUnionFindDelete {
 public:
  ListListBank pd2item;
  vector< uint > item2pd;

  SimpleUnionFindDelete(uint init_size=1024);
  void update_item2pd(uint item, uint pd);

  uint makeset(uint item);
  uint union_(uint p_a, uint p_b);
  uint find_(uint a);  // this a means the item number.
  uint delete_(uint a, uint r);  // a is the item number, r is the pd number

  void print_set(uint p);

};

#endif //UNION_FIND_DELETE_H
